from pprint import pprint

# načtení názvů států ze souboru s plochami
plochy = {} # slovník
with open('staty_plochy.log') as soubor:
    for řádka in soubor:
        stát, plocha = řádka.rstrip('\n').split(': ')
        plochy[stát] = plocha   # pod klíčem stát bude jeho plocha

# načtení názvů států ze souboru s počtem obyvatel
lidi = {}   # slovník
with open('staty_lidi.log') as soubor:
    for řádka in soubor:
        stát, počet_obyvatel = řádka.rstrip('\n').split(': ')
        lidi[stát] = počet_obyvatel # pod klíčem stát bude jeho počet obyvatel

# slovník hustoty zalidnění klíčovaný názvem státu
státy = {}

# počtů obyvatel je méně a všechny jejich státy jsou i v plochách, ale opačně to není pravda -- ploch je o 24 více než lidí
for stát in plochy:
    # pro 24 států neexistuje záznam o počtu obyvatel =>
    try:
        # tento kód selže
        počet_obyvatel = lidi[stát]
    except KeyError:
        # proto ho v případě selhání nahradíme tímto
        počet_obyvatel = 0
    # dál už k chybě nedojde (nemělo by :-)
    plocha = plochy[stát]
    státy[stát] = (
        plocha,
        počet_obyvatel,
        int(počet_obyvatel) / float(plocha)
    )

print(státy)
print(len(státy))   # 261
